/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.shop;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import cz.insophy.inplan.shop.CapabilityIsland;
import cz.insophy.inplan.shop.ShopConfiguration;
import cz.insophy.inplan.shop.Workplace;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class CapabilityIslands {
    private final Map<String, CapabilityIsland> capMap;
    private final Map<Workplace, CapabilityIsland> wpMap;
    private final List<CapabilityIsland> islands;

    private CapabilityIslands(List<CapabilityIsland> islands, Map<String, CapabilityIsland> capMap, Map<Workplace, CapabilityIsland> wpMap) {
        this.islands = islands;
        this.capMap = capMap;
        this.wpMap = wpMap;
    }

    public CapabilityIsland getIsland(String capability) {
        return this.capMap.get(capability);
    }

    public CapabilityIsland getIsland(Workplace workplace) {
        return this.wpMap.get(workplace);
    }

    public List<CapabilityIsland> getIslands() {
        return this.islands;
    }

    public static CapabilityIslands build(ShopConfiguration configuration) {
        return new CapabilityIslandsBuilder(configuration).build();
    }

    private static class CapabilityIslandsBuilder {
        private final ShopConfiguration configuration;
        private final ImmutableMap.Builder<String, CapabilityIsland> capMapBuilder;
        private final ImmutableMap.Builder<Workplace, CapabilityIsland> wpMapBuilder;
        private final ImmutableList.Builder<CapabilityIsland> islandBuilder;
        private final Map<Workplace, Integer> wpOrder;

        CapabilityIslandsBuilder(ShopConfiguration configuration) {
            this.configuration = configuration;
            this.wpOrder = Maps.newIdentityHashMap();
            this.capMapBuilder = ImmutableMap.builder();
            this.wpMapBuilder = ImmutableMap.builder();
            this.islandBuilder = ImmutableList.builder();
            int order = 0;
            for (Workplace wp : configuration.getWorkplaces()) {
                this.wpOrder.put(wp, order);
                ++order;
            }
        }

        public CapabilityIslands build() {
            this.visitAllWorkplaces();
            return new CapabilityIslands((List<CapabilityIsland>)((Object)this.islandBuilder.build()), this.capMapBuilder.build(), this.wpMapBuilder.build());
        }

        private void addIsland(CapabilityIsland island) {
            this.islandBuilder.add((Object)island);
            for (String cap : island.getCapabilities()) {
                this.capMapBuilder.put(cap, island);
            }
            for (Workplace wp : island.getWorkplaces()) {
                this.wpMapBuilder.put(wp, island);
            }
        }

        private void visitAllWorkplaces() {
            HashSet<String> existingNames = Sets.newHashSet();
            Set<Workplace> allVisitedWps = Sets.newIdentityHashSet();
            for (Workplace wp : this.configuration.getWorkplaces()) {
                if (allVisitedWps.contains(wp)) continue;
                HashSet<String> islandCaps = Sets.newHashSet();
                Set<Workplace> islandWps = Sets.newIdentityHashSet();
                this.visitWp(wp, islandWps, islandCaps);
                ArrayList<Workplace> islandWpList = Lists.newArrayList(islandWps);
                Collections.sort(islandWpList, new StaticOrderWpComparator());
                CapabilityIsland island = new CapabilityIsland(islandWpList, islandCaps, existingNames);
                this.addIsland(island);
                existingNames.add(island.getName());
                allVisitedWps.addAll(islandWps);
            }
        }

        private void visitWp(Workplace wp, Set<Workplace> islandWps, Set<String> islandCaps) {
            if (!islandWps.contains(wp)) {
                islandWps.add(wp);
                for (String cap : wp.getCapabilities()) {
                    this.visitCap(cap, islandWps, islandCaps);
                }
            }
        }

        private void visitCap(String cap, Set<Workplace> islandWps, Set<String> islandCaps) {
            if (!islandCaps.contains(cap)) {
                islandCaps.add(cap);
                for (Workplace wp : this.configuration.getWorkplaces(cap)) {
                    this.visitWp(wp, islandWps, islandCaps);
                }
            }
        }

        private class StaticOrderWpComparator
        implements Comparator<Workplace> {
            private StaticOrderWpComparator() {
            }

            @Override
            public int compare(Workplace o1, Workplace o2) {
                return Ints.compare(CapabilityIslandsBuilder.this.wpOrder.get(o1), CapabilityIslandsBuilder.this.wpOrder.get(o2));
            }
        }
    }
}

